MapObjects=
{
    { id="cow_map", x=121, y=148, MinLevel=0, State="left" },
    { id="cow_map", x=95, y=169, MinLevel=0, State="right" }, 
    { id="black_cow_map", x=565, y=121, MinLevel=15, State="left" },
};




CustomMap=
{
    w = 800;
    h = 600;
};

CustomMapButton=
{
    image = "map_button",
    w = 30,
    h = 30,
    x =0,
    y =0,
};

MapButtonGaphics=
{
    "buttons/map_but.png", 
    "buttons/map_but.png", 
    "buttons/map_but.png", 
};

MapButtonStyle=
{
    parent = ButtonStyle,
    graphics = MapButtonGaphics,
};

points=
{
    { image = "button_endles_1", x=87, y=64,  w=174, h=102 },
    { image = "button_endles_2", x=463,y=12,  w=242, h=149 },
    { image = "button_endles_3", x=497,y=240, w=303, h=220 },
    { image = "button_endles_4", x=0,  y=290, w=392, h=267 }  
};

boundary_points = {};  --{1,13,19,22};
local ind_farm = 1;
for ind_farm = 1,4 do
    table.insert(boundary_points, gGlobalGameInfo.gFarm[ind_farm]);
end


backgrounds=
{
    nil,
    nil,
    nil,
    "backgrounds/map_4"    
};

function GetDefBg()
    return "backgrounds/map_1";
end
------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------
__CurrentBg = GetDefBg();
__AddBg = nil;


function GetCurrentBg()
    return __CurrentBg;    
end

function GetAddBg()
    return __AddBg;
end

function CreateAdditionalVisualObj()
    if table.getn(MapObjects)<=0 then return end;
    for i=1, table.getn(MapObjects) do

        if not MapObjects[i].State then MapObjects[i].State = ""; end
        local StartState = MapObjects[i].State;
        
        if( gGlobalPlayerInfo.gLevelNumMax >= MapObjects[i].MinLevel )then
        
            if gGlobalPlayerInfo.gLevelNumMax == MapObjects[i].MinLevel and LastLevelIsNowWinStore then
                StartState = StartState.. "_appear";
            end
            CreateVObject(MapObjects[i].id, MapObjects[i].x, MapObjects[i].y, StartState, MapObjects[i].MinLevel, MapObjects[i].State)
        end
    
    end

end


function SetCurrentBg()
    
    local current_index = 1;
    for i=1, table.getn(boundary_points) do
        if boundary_points[i] and boundary_points[i] <= gGlobalPlayerInfo.gLevelNumMax then
            current_index = i;
        else
            break;
        end
    end
    
    LastLevelIsNowWinStore = LastLevelIsNowWin;
    
    if( backgrounds[current_index] )then
        --ScriptDump("Start2");
    
    
        __CurrentBg = backgrounds[current_index];
       
        if( LastLevelIsNowWin ~= true)then            
            return;
        end;    
        --    
        
        if boundary_points[current_index] ==  gGlobalPlayerInfo.gLevelNumMax then
            local bg = GetDefBg();
            local index = current_index - 1;

            while( index > 0)do
                if(backgrounds[index])then
                    bg = backgrounds[index];
                    break;            
                end
                index = index - 1;
            end
            
            __AddBg = bg;
            
            EffectParams_ = {    
            start_aplha=255, diapason={0, 255}, 
            interval=1400, 
            work_time=1500, 
            visible_after_work=false };
        end
    end
    LastLevelIsNowWin = nil;
end


function Create()

    local map = CustomMap;
    local bpoints={}

    local count = table.getn(boundary_points);
    if( count>0)then
        for i = 1, count do 
            bpoints[ boundary_points[i] ] = i;
        end
    end

    local size_points_array = table.getn(points);
    
    for i = 1, size_points_array do --CPP_GetLastLevelNum()  do
        local custom_button = {};
        
        custom_button.image = points[i].image;
        custom_button.w = points[i].w;
        custom_button.h = points[i].h;
        custom_button.x = points[i].x;
        custom_button.y = points[i].y;
        custom_button.LevelNumber = i;   
        
        map[i] = ButtonMap( custom_button );
        custom_button = nil;
    end
    
    SetCurrentBg();
    
    MakeDialog
    {
        name="game_map_endless",
        Bitmap
        {
            name="background";
            image=GetCurrentBg(),
            x=0,
            y=0,
            w = 800,
            h = 600,
        },
        Bitmap
        {
            name = "add_image";
            image=GetAddBg();
            x=0,
            y=0,
            w=800,
            h=600,            
        },
        
        
        
        GameMap(map);
        Bitmap
        { 
            name="line",
            image="backgrounds/maphint.png",
            x=178,
            y=520;
            Bitmap
            { 
                name="expert",
                image="gamepiece/map_expert.png",
                x=40,
                y=25;
            };
            Text
            {
                font = MyFont,
                name = "result_level",
                font = { standardFont, 30, BlackColor},
                x=10,y=35,w=400,h=50,
                flags = kHAlignCenter,
                label = "empty_text";
            };
        };
        
        SetStyle(MapButtonStyle),
        Button
        {
            x=40,
            y=550,
            name = "main_menu_btn",
            label="main_menu",
            close = true,   -- Just close this window
            command=
                function()
                    if(LoadLevel) then PopModal("thegame");  end
                end         
        },
--[[        
        Bitmap
        {
            name="hiscore_tooltip",
            image="backgrounds/tooltip",   
            x = 40,
            y = 380,          
            Text
            {
                font = { standardFont, 22, BlackColor},
                x=10,y=10,w=430,h=80,
                flags = kHAlignCenter,
                label = "win_hiscore";
            };            
                
        },
--]]        
        
        
        FlashButton1
        {
            --  hiscore
            x=650,
            y=550,
            --tooltip="hiscore_tooltip",
            name = "hiscore_btn",
            label="hiscore_label",
            flash_delay=500;
            flash_min=32;
            flash_max=200;
            command=
                function()
                    DoModal("scripts/hiscore.lua");
                end         
        },
        
    };

    CreateAdditionalVisualObj();
    
    if(EffectParams_)then         
        StartEffect( "add_image" , "alpha_blending", EffectParams_ );
    else
        EnableWindow("add_image", false);
    end    
    
    
    --EnableWindow("hiscore_tooltip", false);
end;

function LoadSelectedLevel(current)
    gCurFarmBegin = 3*current-2;
    gCurFarm = current; 
    DoModal("scripts/endless_difficulty.lua");    
end



function OnBtnMouseLeave(aNumber,aBtnState)
    EnableWindow("expert",false);
    SetLabel("result_level","");
end

function OnBtnMouseMove(aNumber,aBtnState)
    if (aBtnState == 3) then
        EnableWindow("expert",true);
    else
        EnableWindow("expert",false);
    end
    local score = 0;
    local level_info = gGlobalPlayerInfo["lev"..aNumber];
    if (level_info ~= nil) then
        score = level_info.score;
    end
    local label;
    if (aBtnState == 0) then
        label = GetString("map_hint_endless_locked_"..aNumber);
    else
        label = GetString("map_hint_endless_"..aNumber,""..score);
    end
    --ScriptDump(""..score);
    SetLabel("result_level",label);
end


Create();
OnBtnMouseLeave(0,0);

